import 'ant-design-vue/dist/antd.less';
import { createApp, defineComponent, reactive } from 'vue';
import { RouterLink } from './mock-router';
import { Button, message } from 'ant-design-vue';
import { default as ProLayout } from '../src/';
import { menus } from './menus';
import { useMenuState } from '../src/SiderMenu/BaseMenu';
import * as Icon from '@ant-design/icons-vue';
import { createRouteContext } from '../src/RouteContext';

const BasicLayout = defineComponent({
  name: 'BasicLayout',
  inheritAttrs: false,
  setup(_, { attrs }) {
    const [menuState] = useMenuState({
      collapsed: false,
      openKeys: [],
      selectedKeys: ['/welcome'],
    });

    const [ routeContext, RouteContextProvider ] = createRouteContext({
      isMobile: false,
      menuData: [],
      sideWidth: 208,
      hasSideMenu: true,
      hasHeader: true,
      hasFooterToolbar: false,
      setHasFooterToolbar: (has: boolean) => (routeContext.hasFooterToolbar = has),
    });

    return () => (
      <RouteContextProvider>
        <ProLayout
          {...attrs}
          v-model={[menuState.collapsed, 'collapsed']}
          title={'Pro Layout'}
          layout={'side'}
          theme={'dark'}
          i18n={(key: string) => key}
          isMobile={false}
          menuData={menus}
          matchMenuKeys={[]}
          contentWidth={'Fixed'}
          primaryColor={'#1890ff'}
          siderWidth={208}
          openKeys={menuState.openKeys}
          selectedKeys={menuState.selectedKeys}
          onOpenChange={$event => {
            $event && (menuState.openKeys = $event);
          }}
          onSelect={$event => {
            $event && (menuState.selectedKeys = $event);
          }}
          v-slots={{
            footerRender: () => (
              <div>123</div>
            )
          }}
        >
          <Button
            onClick={() => {
              message.info('clicked.');
            }}
          >
            Click Me!!
          </Button>
        </ProLayout>
      </RouteContextProvider>
    );
  },
});

const SimpleDemo = {
  setup() {
    return () => (
      <div class="components">
        <h2># BasicLayout</h2>
        <BasicLayout />
      </div>
    );
  },
};

const app = createApp(SimpleDemo);

const filterIcons = ['default', 'createFromIconfontCN', 'getTwoToneColor', 'setTwoToneColor'];
Object.keys(Icon)
  .filter(k => !filterIcons.includes(k))
  .forEach(k => {
    app.component(Icon[k].displayName, Icon[k]);
  });

app.use(RouterLink).use(ProLayout).mount('#__vue-content>div');
